#! /bin/bash
set -e

notar=false
# Check if the last argument is "--notar"
if [[ "${@: -1}" == "--notar" ]]; then
  notar=true
  set -- "${@:1:$(($#-1))}"  # Remove the last argument from the list
fi

compose_file_path=$1
project_name=$2
backup_path=$3
work_dir=`pwd`

# compatibility for win
if [[ "$(expr substr $(uname -s) 1 5)" == "MINGW" ]]; then
  work_dir=`pwd -W`
fi

#checking compose_file_path availability
if [ ! -f $compose_file_path ]; then
  echo "'$compose_file_path' not found"
  exit 1
fi

#checking backup_path availability
if ! $notar && [ ! -f $backup_path ]; then
  echo "File '$backup_path' not found"
  exit 1
elif $notar && [ ! -d $backup_path ]; then
  echo "Directory '$backup_path' not found"
  exit 1
fi


echo "Stopping running containers..."
volumes=($(docker volume ls -f name=$project_name | awk '{if (NR > 1) print $2}'))
docker compose -f $compose_file_path --project-name $project_name down

echo "Mounting volumes and performing restore backup..."

if ! $notar; then
  echo "Extracting backup..."
  tar -xf $backup_path
  for v in "${volumes[@]}"
  do  
    docker volume rm $v > /dev/null
    docker volume create $v > /dev/null
    arc="$v".tar.bz2
    if [ -f "$v".tar.bz2 ]; then	
      docker run -v $v:/volume:rw -v $work_dir:/backup --rm loomchild/volume-backup restore $arc && echo "$v success"
      rm -f $arc	
    else
      echo "$v skipped"
    fi
  done
elif $notar; then
  for v in "${volumes[@]}"
  do  
    docker volume rm $v > /dev/null
    docker volume create $v > /dev/null
    arc="$v".tar.bz2
    if [ -f "${backup_path}/${arc}" ]; then	
      docker run -v $v:/volume:rw -v $work_dir/$backup_path:/backup --rm loomchild/volume-backup restore $arc && echo "$v success"
    else
      echo "$v skipped"
    fi
  done
fi

echo "Restarting containers..."
docker compose -f $compose_file_path --project-name $project_name up -d

echo "Backup ${backup_path} restored"
