#!/bin/bash

PROJECT_NAME=$1
shift
# Move migration volumes to original volumes and cleanup

migration_volumes="$@"
for volume in $migration_volumes; do
    volume_original="$(sed s/new-//g <<<$volume)"
    # add check for existing new-volume!!!
    if ! [ $(docker volume ls | grep -c $volume) -gt 0 ]; then 
        continue;
    else
        rm -rf $(docker inspect "${PROJECT_NAME}_${volume_original}" --format '{{ .Mountpoint }}')
        mv $(docker inspect "${PROJECT_NAME}_${volume}" --format '{{ .Mountpoint }}') $(docker inspect "${PROJECT_NAME}_${volume_original}" --format '{{ .Mountpoint }}' | sed s/_data//g)
        docker volume rm "${PROJECT_NAME}_${volume}"
    fi
done

# EXAMPLE USAGE:
# ./move-migrated-volumes testit new-minio-volume new-db-volume