#! /bin/bash
set -e

notar=false
# Check if the last argument is "--notar"
if [[ "${@: -1}" == "--notar" ]]; then
  notar=true
  set -- "${@:1:$(($#-1))}"  # Remove the last argument from the list
fi

compose_file_path=$1
project_name=$2
work_dir=`pwd`

# compatibility for win
if [[ "$(expr substr $(uname -s) 1 5)" == "MINGW" ]]; then
  work_dir=`pwd -W`
fi

start_containers() {
  echo "Restarting containers..."
  COMPOSE_HTTP_TIMEOUT=120 DOCKER_CLIENT_TIMEOUT=120 docker compose -f $compose_file_path --project-name $project_name start
}

#checking compose_file_path availability
if [ ! -f $compose_file_path ]; then
  echo "'$compose_file_path' not found"
  exit 1
fi

echo "Stopping running containers..."
docker compose -f $compose_file_path --project-name $project_name stop

echo "Mounting volumes and performing backup..."
volumes=($(docker volume ls -f name=$project_name | awk '{if (NR > 1) print $2}'))

if ! $notar; then 
  arch_name="backup_$(date +"%d_%m_%Y").tar"
  rm -f $arch_name
  for v in "${volumes[@]}"
  do
    arc="$v".*.bz2
    if [[ $(docker run -v $v:/volume:ro -v $work_dir:/backup --rm --entrypoint sh loomchild/volume-backup -c 'ls -A /volume') ]]; then
      docker run -v $v:/volume:ro -v $work_dir:/backup --rm loomchild/volume-backup backup $v && echo "$v success"
      tar --append --file=$arch_name $arc
      rm -f $arc
    else
      echo "$v skipped"
    fi
  done
  start_containers
  echo "Backup ready: ${arch_name}"
elif $notar; then
  backup_dir="${work_dir}/backup_$(date +"%d_%m_%Y")"
  if [ -d $backup_dir ]; then rm -rf $backup_dir; fi
  for v in "${volumes[@]}"
  do
    if [[ $(docker run -v $v:/volume:ro -v $backup_dir:/backup --rm --entrypoint sh loomchild/volume-backup -c 'ls -A /volume') ]]; then
      docker run -v $v:/volume:ro -v $backup_dir:/backup --rm loomchild/volume-backup backup $v && echo "$v success"
    else
      echo "$v skipped"
    fi
  done
  start_containers
  echo "Backup ready: ${backup_dir}"
  ls -l $backup_dir
fi
