# Changelog

All notable changes to this project will be documented in this file.


## [5.6.0] Equuleus - 27.01.2026

### Added

- AI test generation:
   - Connecting up to 3 AI-services to 1 project
   - Select AI-generated test cases
   - Editing test cases on test generation page
   - 4 extra AI models by YandexGPT available
- Test plans:
   - Smart search by tags and their combinations
   - Attributes on test point page
- Manual testing:
   - Smart search by tags and their combinations
   - Improved toolbar in test library
   - Unique parameter name for creating parameters on test case page
- Automated testing:
   - Test IT Management plugin improvements:
      - Test IT Management for Visual Studio Code
      - Replace decorator functionality in adapters for JUnit and Playwright
   - Integration with Vanessa Automation
   - Spaces support in adapter for Cucumber
   - Improved webhook functionality
- Dashboards:
   - Widget for link coverage of test cases

### Fixed

 - Bug fixes and performance improvements

## [5.5.0] Libra - 09.10.2025

### Added

- Test management:
   - Filtering parameters not linked to projects
   - Sorting configurations by date
   - Specifying projects when creating or editing parameters
- AI test generation:
   - Ability to connect any OpenAI-compatible model
   - Breaking down AI-generated test cases by steps
   - Automatic linking AI-generated test cases to their source tasks
   - Selecting AI model when adding integrations to projects
- Manual testing:
   - Filtering tests by links and task tracker metadata
   - Improved section copying: Copying pre- and postconditions and skipping parent sections
   - Test duration in exported Excel-documentation
- Test plans:
   - Corying GUIDs of test-plan, test-suite, and configuration from the UI
   - Auto-assign QA engineers when setting test results
   - Ability to specify webhooks when launching automated tests from test plan
- Test automation:
   - Ability to specify webhooks when relaunching automated tests
   - Copying autotest error message in 1 click
   - Applying error categories to various projects
   - Improved migrator for Zephyr Scale Server: Iterative migration and exporting archived tests
   - Test IT Management plugin supporting OpenIDE
- System Administration
  - Enhanced functionality of AD/LDAP connection

### Fixed

 - Bug fixes and performance improvements

## [5.4.0] Sagitta - 03.07.2025

### Added

- Projects:
   - Marking a project as favourite/unfavourite in the project window
   - Parameter and attribute settings moved to the the "Projects settings" menu in the upper navigation panel
   - Specifying projects when creating or editing parameters
- Manual testing:
   - Displaying and filtering AI-generated tests in the Test library
   - New interface for adding shared steps to test cases
   - Tag length extended from 30 to 255 characters
- Test plans:
   - Combined "Planning" and "Execution" tabs
- Test Automation:
   - List of available webhooks displayed in the "Launch autotests" window
- User experience
   - Expandable "Description" field in webhooks and attributes
- System Administration
  - Adding imgproxy to microservice architecture

### Fixed

 - Bug fixes and performance improvements

## [5.3.0] Reticulum - 15.04.2025

### Added

- Projects:
   - Improved project navigation panel
   - "Multiple choice" attribute applicable to projects 
- Manual testing:
   - AI-powered test case creating
   - Filtering test cases by links
   - Extended information in test cases exported in .xlsx
- Test plans:
   - Creating test plans from test library
   - Integration with Yandex Tracker
- Test Automation:
   - Autotest deletion
   - Preview attachments to autotest results in .txt, .yaml, .json, .xml, .sh
- Analytics:  
   - Dashboards in printer-friendly format
- User experience
   - Ability to add external links to upper navigation panel
- System Administration
  - Transition to new Helm Chart
  - Migration from Redis to Valkey
  - Updated RabbitMQ

### Fixed

 - Bug fixes and performance improvements


## [5.2.4] - 27.02.2025

### Fixed

 - Fixed issue with HTTP-redirect in connections via OpenID connect


## [5.2.2] - 31.01.2025

### Fixed

 - Only current test case versions are exported
 - OpenID connection in 5.2.0 fixed
 - Minor bug fixes and performance improvements
 	

## [5.2.1] - 27.06.2024

### Fixed

 - Fixed issue with self-signed certificates
 - Minor bug fixes and performance improvements

## [5.2.0] Telescopium - 12.12.2024

### Added

- Projects:
   - Access to project archive: editing
- Manual testing:
   - Comment counter in work items
   - Ability to save a created work item and proceed to the new one
   - Details block in work item editor
- Automated testing:
   - Automatic relaunching failed autotests
   - Automatic marking flaky tests
   - Relaunching autotests from test runs
   - Streamlined creation of error categories
   - Creating defects on autotests in task-trackers
   - Copying ID of a project, configuration, test run and autotest
   - Test run deletion
   - Viewing configurations in test run lists
   - Integration with Kotest
- Test plans:
   - Improved test plan information panel
   - Saving input data for test plan report
   - Saving filter parameters when copying test plan's URL	
- Integrations with task-trackers:
   - Integration with Kaiten
- Dashboards:
   - Auto-generating widget name
- Migration from TMS:  
   - Migrator for Qase 
- User experience:  
   - View test mapping in sections
   - Unique API token name
   - Free access for read-only users (new system role: Observer) 
- System administration:  
   - RabitMQ consumer removed from the installation package
   - Functionality of webapi, backoground-service, globalsearh-service is combined in the Docker image of registry.testit.software/testit/testit

### Fixed
​
 - Bug fixes and performance improvements


## [5.1.2] - 25.10.2024
​
### Fixed
​
 - Bug fixes and performance improvements

## [5.0.3] - 27.06.2024
​
### Fixed
​
 - Bug fixes and performance improvements

## [5.0.2] - 19.06.2024
​
### Fixed
​
 - Bug fixes and performance improvements

## [5.0.1] - 07.06.2024

### Added

- Integrations with task trackers:
  - Integration with EvaProject (ability to create tasks in EvaProject from Test IT's UI)

## [5.0.0] Lynx - 30.05.2024

### Added

- Manual testing:
  - Text document preview in test cards (Word, Excel, and PDF files)
- Test plans:
   - Simplified test plan creation and editing
   - Simplified test result setting
   - Test version preview
   - Test results breakdown (absolute terms and percentage)
   - Test plan report: test points with all statuses in the defect list 
- Webhooks:
   - Extended list of webhook parameters	
- Automated testing:
   - Parametrized autotest launches
   - Integration with GitFlic
   - Test IT Management plugin for IntelliJ IDEA
   - Test run deletion and restoration via API	
- API:
   - Creating multiple tokens	
- User experience:
   - Setting user level icon as avatar (optional)
   - Moderate gamification
   - Extended storage time for archived tests and attachments to test results (up to 180 days)
 - Migration from TMS:  
   - Migrator for Zephyr Squad Server 

### Fixed
​
 - Bug fixes and performance improvements

## [4.6.0] Chamaeleon - 18.03.2024

### Added

- Improved user experience:
   - Dark theme
   - Option to paste images from clipboard
   - Notifications about user achievements in the UI
   - Applications page containing information about system settings and integrations
   - Hidden API token
 - Manual testing:
   - Test import from the Test library page (TestRail XML and .xlsx)
   - Tag library
 - Automated testing:
   - New test run filters: ID, name, error category, creation date, duration
   - Integration with Marathon Cloud
 - Integrations with task trackers:
   - Easy Redmine
   - Monday
 - Automated migrators:
   - Migrator for TestRail
 - Analytics:
   - Improved and simplified widget creation workflow
 - System administration:  
   - All the basic Test IT services switch to Alpine (Docker Compose and Kubernetes)

### Fixed
​
 - Bug fixes and performance improvements

## [4.5.1] - 08.02.2024
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.5.0] Lacerta - 18.12.2023

### Added

 - Added new functionality to the **Projects** module. Now you can:
   - Export projects in bulk from the UI
   - Import projects in bulk from the UI
 - Improved the manual testing functionality. You can:
   - Group tests by attributes
   - Open test points using their URLs from the **Planning** and **Execution** tabs of the **Test plans** section
 - Added new bugtrackers to integrate with and streamlined the integration processes. You can:
   - Integrate with ClickUp
   - Integrate with Redmine
   - Integrate with YouTrack
   - Connect projects to bug trackers using fewer steps
 - Automated migration from new TMS systems. You can now automatically migrate to Test IT from:
   - Spiratest
   - TestCollab
   - TestLink
   - Xray
   - Zephyr Scale
   - Zephyr Squad
 - Enhanced the Administration options. You can:
   - Enable and disable gamification for all users
 - Made some useful changes to the user profile. Now you can:  
   - Access your tasks from the **User profile** tab
   - Use the improved gamification system with updated UI and a variety of achievements
   - Work with test runs' attachments
 - Made the **Test plans** module more user-friendly. You can:
   - Save filters when switching between test plan sections
 - Improved the UX. Now you can:
   - Use hotkeys to work with modal windows, work items, and test points
   - Create error categories, configurations, and project attributes in a simplified way

### Fixed
​
 - Bug fixes and performance improvements


## [4.5.1] - 08.02.2024
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.5.0] Lacerta - 18.12.2023

### Added

 - Added new functionality to the **Projects** module. Now you can:
   - Export projects in bulk from the UI
   - Import projects in bulk from the UI
 - Improved the manual testing functionality. You can:
   - Group tests by attributes
   - Open test points using their URLs from the **Planning** and **Execution** tabs of the **Test plans** section
 - Added new bugtrackers to integrate with and streamlined the integration processes. You can:
   - Integrate with ClickUp
   - Integrate with Redmine
   - Integrate with YouTrack
   - Connect projects to bug trackers using fewer steps
 - Automated migration from new TMS systems. You can now automatically migrate to Test IT from:
   - Spiratest
   - TestCollab
   - TestLink
   - Xray
   - Zephyr Scale
   - Zephyr Squad
 - Enhanced the Administration options. You can:
   - Enable and disable gamification for all users
 - Made some useful changes to the user profile. Now you can:  
   - Access your tasks from the **User profile** tab
   - Use the improved gamification system with updated UI and a variety of achievements
   - Work with test runs' attachments
 - Made the **Test plans** module more user-friendly. You can:
   - Save filters when switching between test plan sections
 - Improved the UX. Now you can:
   - Use hotkeys to work with modal windows, work items, and test points
   - Create error categories, configurations, and project attributes in a simplified way

### Fixed
​
 - Bug fixes and performance improvements



## [4.4.3] - 12.10.2023
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.4.2] - 27.09.2023
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.4.1] - 14.09.2023
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.4.0] - 11.09.2023

### Added

 - The Tiptap toolkit is implemented in the product. Now you can:
   - Add tables to test steps
   - Use the Tiptap-powered step editor
   - Use the Tiptap-powered interface with images in the step editor
   - Manage parameters with an improved mechanism
   - Edit links using the Tiptap tool
   - Add code in the step editor
   - Edit steps using a toolbar, including work with **Test Data** and **Comment** columns in WI
   - Work with change history based on the Tiptap functionality
 - Improved the **Administration** module. You can:
   - Create global attributes of a **Checkbox** type, make it mandatory or optional for further use in projects, including WI and test plans (the **Administrator** system role is required)
   - Import test cases from TestRail to seamlessly switch to Test IT (permission to import check-cases is required)
   - Import and export the **Checkbox** attribute in XLSX
 - Improved the analytics (**Dashboards** module). You can:
   - View the actual and planned test plan execution time on the diagram that breaks up tests by QA engineers
   - View median and actual time of test case completion
   - Create autotest completion reports
   - Use a new component: Selecting integer intervals (UX improvement)
   - Use a new component: Selecting intervals (duration; UX improvement)
 - Improved the search options. Now you can:
   - Find an entity by its name or ID using the **Global Search** option to save time you spend on manual search
   - Filter the test run list by test run attributes.
 - Extended webhook functionality that allows you to:
   - Send object arrays via webhooks
   - Set webhook notifications triggered by creating, editing, or archiving a test plan
   - Set webhook notifications triggered by creating, editing, or archiving a project
 - An option to export test cases from TestRail as tables  
 - Test run editing options. You can:
   - Edit a single test run
   - Edit test runs in bulk
   - Work with links in test runs
   - Work with test runs' attachments
 - Official Kubernetes support
 - Allure-importer that allows flawless migration of labeled Test IT autotests
 - Extended archive managing functionality that allows you to:
   - Clear the system archive
 - TeamStorm integration. Now you can:
   - Create issues
   - Display issue data

### Fixed
​
 - Bug fixes and performance improvements

## [4.3.1] - 14.08.2023
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.3.0] Gemini - 03.07.2023
​
### Added
​
 - Auto-update of dynamic test suites
 - An option to set auto-update for dynamic test suites on the creation and editing stages
 - Burndown chart
 - **Clear** button in the **Archive** tabs for the following elements:
   - Projects
   - Test plans
   - Test cases
   - Configurations
 - New service in docker-compose: licensedb
 - .env variables:
   - POSTGRES_LICENSE_DB
   - POSTGRES_LICENSE_USER
   - POSTGRES_LICENSE_PASSWORD
   - LICENSE_DB_CONNECTION_STRING
​
### Changed
​
 - Updated auth service
 - Revisited webhooks:
   - Test plan status change
   - Autotest launch
   - Test point assignment
   - Selecting a user in a work item attribute
   - Tagging a user
   - Completing all test points
   - Creating a Jira issue from a test plan
   - Completing all autotests
   - Autotest completion
   - Test run stop
   - Autotest change
   - Changing relation between autotest and work item
   - Project change
   - Work item change
   - Configuration change
   - Work item attribute change
   - Testing the URL availability during webhook setup
 - Enhanced custom test suites functionality 
 - Revisited functionality of auto-updating test plan status when results test results are set
 - Switching from Backoffice to TMS
 - UX/UI improvements:
   - Smaller fonts and intervals in the right navigation bar and filter panel
   - Updated UI of test suites from sections
   - Smaller line spacing in dropdown menus
   - Improved user profile interface
   - Rearranged menu structure (second-level menus are removed from the product)
   - Fixed **Action** and **Selection** columns in tables
   - Smaller **Columns** and **Filter** buttons above table headers
 - Removed service in docker-compose: cleanup-service
 - Renamed service in docker-compose: transfer-service > background-service
 - Updated third-party container images:
   - postgres:14.7-bullseye > postgres:14.8-bookworm
   - minio/minio:RELEASE.2023-04-20T17-56-55Z > minio/minio:RELEASE.2023-05-04T21-44-30Z
   - elasticsearch:8.7.0 > elasticsearch:8.8.1
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.2.4] - 06.06.2023
​
### Fixed
​
 - Bug fixes and performance improvements

## [4.2.3] - 31.05.2023

### Fixed

 - Bug fixes and performance improvements

## [4.2.0] Dorado - 27.04.2023

### Added

 - An updated form for creating a bug in Jira (for Test IT). In the Description field, the following information is available and can be populated:
   - Test case steps
   - Test point step results (if specified)
   - Comments on test point steps (if made)
   - Comments on test point
 - Read-only mode for archived entities: All the archived entities get blocked for the use and available for reading only
 - An option to assign a user to a configuration in the Execution tab
 - An option to modify a test plan via an editable header
 - Upgraded report template with an option to print out a report with attachments and comments on test points and their steps 
 - Migration to PostgreSQL 14 (refer to docs for update guide -  https://docs.testit.software/installation-guide/update-system.html)
 - New image processing library 
 - General UX/UI improvements
 - Integrations
   - Dotnet adapter for MSTest and NUnit (https://github.com/testit-tms/adapters-dotnet)
   - New tags/decorators for Python and .js-adapters: Namespace and Classname
   - A new parameter for TestIT CLI that allows splitting a classname into a namespace and a classname (https://docs.test-gear.io/user-guide/integrations/cli.html)
   - Clients for the TMS version 4.2
 - New service in docker-compose: cleanup-service
 - .env variables:
   - AVATARS_FILE_BUCKET_NAME
   - KIBANA_SERVER_HOST

### Changed

 - Updated third-party container images
  - postgres:10.23-bullseye > postgres:14.7-bullseye (refer to docs for update guide -  https://docs.testit.software/installation-guide/update-system.html)
  - minio/minio:RELEASE.2022-10-24T18-35-07Z > minio/minio:RELEASE.2023-04-20T17-56-55Z (refer to docs for update guide -  https://docs.testit.software/installation-guide/update-system.html)
  - redis:6.2.10-bullseye > redis:6.2.12-bullsey
  - elasticsearch:7.17.9 > elasticsearch:8.7.0

### Fixed

 - Bug fixes and performance improvements

## [4.1.0] Corvus - 28.03.2023

### Added 

 - Dynamic test suites have been added
 - The test suites list is now displayed on the test plan page
 - A new WI display format has been added to the "Manual Tests" page - Breadcrumbs
 - Background tasks mechanism has been added for import and export tasks
 - The archive management
   - The management of archived items has been improved, including tests, configurations, and test plans
   - The management of archived projects now occurs at the system level
   - New permissions in project roles have been added for archive management
 - API improvements
   - PATCH methods are now available for WI
   - Attachments can now be uploaded to WI
 - .env variables
   - POSTGRES_BACKGROUND_DB
   - POSTGRES_BACKGROUND_USER
   - POSTGRES_BACKGROUND_PASSWORD
   - BACKGROUND_CONNECTION_STRING

### Fixed

 - Bug fixes and performance improvements

### Changed

 - Updated third-party container images: rabbitmq:3.9.29-alpine

## [4.0.2] Phoenix - 23.03.2023

### Fixed

 - Bug fixes and performance improvements

## [4.0.1] Phoenix - 13.03.2023

### Added 

 - Yoonion Core Platform
 - Страница выбора продукта
 - Единая страница аутентификации в продукты Yoonion
 - Роль Администратор Core
 - Возможность переключения между продуктами Yoonion
 - Логотип Yoonion на общих страницах
 - В .env добавлены переменные 
    - COMPOSE_NETWORK_NAME
    - POSTGRES_PORT
    - CWM_ENABLED
    - CWM_S3_BUCKET_SECRET_KEY

### Changed

 - Переименованы переменные: 
    - DOCKER_REGISTRY    > TMS_DOCKER_REGISTRY
    - CONTAINER_VERSION  > TMS_CONTAINER_VERSION
    - FILE_BUCKET_NAME   > TMS_FILE_BUCKET_NAME
 - Переименована сеть по умолчанию из testit_network в yoonion_network
 - Сеть по умолчанию указывается как external и должна быть создана перед запуском проекта
 - Версия файла docker-compose обновлена до версии 3.5


## [4.0.0] Phoenix - 27.02.2023

### Redesign

- Меню пользователя
- Меню системы
- Меню проекта
- Профиль пользователя
- Настройки пользователя
- Страница авторизации 
- Страница "Проекты"
- Страница "Запросы"
- Страница "Дашборды"
- Страница "Параметры"
- Страница "Дашбордов"
- Страница "Уведомления"
- Раздел "Проект” и все вложенные разделы
- Проработанный новый лоадер
- Новый дизайн дерева секций
- Логирование Вебхуков
- Переработаны шрифты, иконки и цвета
- Фильтры и сортировка в едином формате
- Кнопки основных действий в едином формате

### Enhancements

- Расширен API v2
- Изменена структура docker-compose.elk.yml  - https://docs.testit.software/installation-guide/log-user-actions.html

### Security

- Все образы контейнеров Test IT теперь запускаются от пользователя testit или nginx. - https://docs.testit.software/installation-guide/update-system.html
- Обновлены сторонние образы контейнеров: postgres:10.23-bullseye, rabbitmq:3.9.22-alpine, minio/minio:RELEASE.2022-10-24T18-35-07Z, redis:6.2.10-bullseye, elasticsearch:7.17.9

### Added 

- Allure-proxy
- Адаптеры
  - Java
    - TestNg https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-testng 
    - Junit4 https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-junit4 
    - Junit5 https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-junit5 
    - Cucumber4 https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-cucumber4 
    - Cucumber5 https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-cucumber5 
    - Cucumber6 https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-cucumber6 
    - Cucumber7 https://github.com/testit-tms/adapters-java/tree/main/testit-adapter-cucumber7 
    - JBehave https://github.com/testit-tms/adapters-java/tree/v1.1.4/testit-adapter-jbehave 
  - Python
    - Pytest https://github.com/testit-tms/adapters-python/tree/main/testit-adapter-pytest 
    - Behave https://github.com/testit-tms/adapters-python/tree/main/testit-adapter-behave 
    - RobotFramework https://github.com/testit-tms/adapters-python/tree/main/testit-adapter-robotframework 
  - JS
    - Cucumber 1-7 https://github.com/testit-tms/adapters-js/tree/main/testit-adapter-cucumber 
    - Jest -https://github.com/testit-tms/adapters-js/tree/main/testit-adapter-jest 
    - Codecept - https://github.com/testit-tms/adapters-js/tree/main/testit-adapter-codecept 
- Клиенты
  - Java https://github.com/testit-tms/api-client-java 
  - Python https://github.com/testit-tms/api-client-python 
  - JS https://github.com/testit-tms/api-client-js 
  - .Net https://github.com/testit-tms/api-client-dotnet
