# Описание values

## Структура файла

Файл values.yaml логически разбит на разделы:
1. Общие компоненты statefulset, которые могут быть использованы вне состава сборки testit:
    - auth-cache (valkey/redis)
    - postgres
    - rabbitmq
    - influxdb
    - minio
2. Компоненты приложения testit бэкенд:
    - gotenberg-api
    - license-service
    - avatars-api
    - auth
    - ldapwebapi
    - webapi
    - background-service
    - globalsearch-service
3. Компоненты приложения testit фронтенд:
    - frontend
4. Раздел значений по-умолчанию для всех компонент:
    - default
5. Раздел общих значений переменных, томов и секретов:
    - general
6. Раздел общих значений репозитория и тэга:
    - image

## Компоненты к деплою

Каждый компонент требующий деплоя в релиз имеет ключ ```enabled: true```  
Для выключения необходимых общих компонент из состава релиза, например в случае использования внешних БД, необходимо указать ```enabled: false```

## Hostname приложения

Для определения хостнейма приложения testit необходимо указать значения двух ключей:
- ```frontend.ingress.main.host```
- ```webapi.ingress.main.host```

## Изменение расположения переменных окружения в версии 5.3.0

До версии 5.3.0 большинство переменных окружения задавались через жесткое определение внутри шаблонов ConfigMaps. Начиная с версии 5.3.0 все переменные вынесены в разделы:
- config (явное задание переменной для сервиса)
- envFromSecret ("поштучное" задание переменной из указанного secret)
- envFromConfigMap ("поштучное" задание переменной из указанной ConfigMap)
- general.config (задание переменных окружения для всех сервисов исключая те, которые имеют ключ ```excludeGeneralConfig: true```)

### Список изменения расположения переменных по сервисам:
#### auth:
| Переменная                                      | Старое расположение         | Новое расположение                               |
|-------------------------------------------------|-----------------------------|--------------------------------------------------|
| ASPNETCORE_ACCESS_TOKEN_EXPIRATIONs_MINUTES      | configmap auth.yaml         | auth.config                                      |
| ASPNETCORE_REFRESH_TOKEN_EXPIRATION_MINUTES     | configmap auth.yaml         | auth.config                                      |
| ASPNETCORE_ENVIRONMENT                          | configmap auth.yaml         | auth.config                                      |
| SYNC_LDAP_USERS_ON_LOGIN                        | configmap auth.yaml         | auth.config                                      |
| BackgroundSyncSettings__IntervalInMinutes       | configmap auth.yaml         | auth.config                                      |
| SYSTEM_NAME                                     | configmap auth.yaml         | auth.config                                      |
| COMPlus_EnableDiagnostics                       | configmap auth.yaml         | auth.config                                      |
| APPLICATION__CONFIGURATION__CUSTOMFILEPATH      | configmap auth.yaml         | auth.config                                      |
| CAN_EDIT_SYSTEM_ROLES                           | configmap auth.yaml         | auth.config                                      |
| Serilog__SystemAll__WriteTo__1__Name             | configmap auth.yaml         | auth.config                                      |
| Serilog__AdminAll__WriteTo__1__Name              | configmap auth.yaml         | auth.config                                      |
| AUTH_CONNECTION_STRING                          | auth.db (auth.yaml)         | general.secrets.AUTH_DB_CONNECTION_STRING         |
| AUTH_CACHE_CONNECTION_STRING                    | configmap auth.yaml         | general.secrets.AUTH_CACHE_CONNECTION_STRING      |

#### license-service:
| Переменная                                           | Старое расположение             | Новое расположение                                    |
|------------------------------------------------------|---------------------------------|-------------------------------------------------------|
| LICENSE_DB_CONNECTION_STRING                         | license.db (license.yaml)       | general.secrets.LICENSE_DB_CONNECTION_STRING           |
| Redis__ConnectionString                              | configmap license.yaml          | general.secrets.AUTH_CACHE_CONNECTION_STRING           |
| ASPNETCORE_ENVIRONMENT                               | configmap license.yaml          | license.config                                       |
| COMPlus_EnableDiagnostics                            | configmap license.yaml          | license.config                                       |
| APPLICATION__CONFIGURATION__CUSTOMFILEPATH           | configmap license.yaml          | license.config                                       |
| Application_RefreshActiveLicensesCache_Enabled       | configmap license.yaml          | license.config                                       |
| Application_RefreshActiveLicensesCache_DelayInMinutes | configmap license.yaml          | license.config                                       |

#### avatars-api:
| Переменная                                      | Старое расположение                      | Новое расположение                                  |
|-------------------------------------------------|------------------------------------------|-----------------------------------------------------|
| AVATARS_CONNECTION_STRING                       | avatars.db (avatars.yaml)                | general.secrets.AVATARS_DB_CONNECTION_STRING         |
| ASPNETCORE_ENVIRONMENT                          | configmap avatars.yaml                   | avatars.config                                      |
| AVATARS_AWS_CONNECTION_STRING                   | configmap avatars.yaml                   | avatars.config                                      |
| Redis__ConnectionString                         | configmap avatars.yaml                   | general.secrets.AUTH_CACHE_CONNECTION_STRING         |
| AVATARS_AWS_ACCESS_KEY                          | configmap avatars.yaml                   | general.secrets.AWS_ACCESS_KEY                       |
| AVATARS_AWS_SECRET_KEY                          | configmap avatars.yaml                   | general.secrets.AWS_SECRET_KEY                       |
| AWSS3Server__BucketName                         | configmap avatars.yaml                   | avatars.config                                      |
| WEBAPI_URL                                      | configmap avatars.yaml                   | avatars.config                                      |
| COMPlus_EnableDiagnostics                       | configmap avatars.yaml                   | avatars.config                                      |
| INFLUX_DISABLE_UPLOAD                           | configmap avatars.yaml                   | avatars.config                                      |
| APPLICATION__CONFIGURATION__CUSTOMFILEPATH      | configmap avatars.yaml                   | avatars.config                                      |
| AVATARS_AWS_CREATE_BUCKET_IF_REQUIRED           | configmap avatars.yaml                   | avatars.config                                      |

#### ldapwebapi:
| Переменная                                | Старое расположение  | Новое расположение  |
|-------------------------------------------|----------------------|---------------------|
| ASPNETCORE_ENVIRONMENT                      | configmap ldap.yaml  | ldapwebapi.config   |
| COMPlus_EnableDiagnostics                  | configmap ldap.yaml  | ldapwebapi.config   |
| APPLICATION__CONFIGURATION__CUSTOMFILEPATH | configmap ldap.yaml  | ldapwebapi.config   |

#### webapi:
| Переменная                   | Старое расположение         | Новое расположение                                 |
|------------------------------|-----------------------------|----------------------------------------------------|
| DB_CONNECTION_STRING         | webapi.db (webapi.yaml)     | general.secrets.TESTIT_DB_CONNECTION_STRING         |
| Hangfire__DbConnectionString | webapi.db (webapi.yaml)     | general.secrets.BACKGROUND_DB_CONNECTION_STRING       |

#### background-service:
| Переменная                   | Старое расположение                                      | Новое расположение                                 |
|------------------------------|----------------------------------------------------------|----------------------------------------------------|
| Tms__DbConnectionString      | backgroundService.db (background-service.yaml)           | general.secrets.TESTIT_DB_CONNECTION_STRING         |
| Hangfire__DbConnectionString | backgroundService.db (background-service.yaml)           | general.secrets.BACKGROUND_DB_CONNECTION_STRING       |

#### globalsearch-service:
| Переменная                  | Старое расположение                         | Новое расположение                                    |
|-----------------------------|---------------------------------------------|-------------------------------------------------------|
| Tms__DbConnectionString      | globalsearch.db (globalsearch.yaml)         | general.secrets.GLOBALSEARCH_DB_CONNECTION_STRING       |

#### frontend:
| Переменная          | Старое расположение            | Новое расположение |
|---------------------|--------------------------------|--------------------|
| NGINX_JSON_LOGGING  | configmap frontend.yaml        | frontend.config    |

## Изменение расположения самоподписанных сертификатов в версии 5.3.0

До версии 5.3.0 для добавления самоподписанных сертификатов в контейнере их необходимо было указывать в ConfigMap ./testit_backend/templates/configmaps/ssl/ca-bundle.yaml Начиная с версии 5.3.0 сертификаты необходимо располагать в директории ./files/ssl/ в формате pem-сертификатов. Включение сертификатов в контейнеры осуществяется в разделе general.volumes и general.configFile (см. для примера файл values-ssl.yaml)

## Изменение включения режима read-only для файловой системы контейнеров

До версии 5.3.0 параметр ```SecurityContext.Container.readOnlyRootFilesystem: true``` располагался в корневом разделе values. Начиная с версии 5.3.0 данный параметр перенесен в раздел ```default.containerSecurityContext.readOnlyRootFilesystem: true```. Также для функционирования системы в режиме read-only необходимо включить emptydir тома для некоторых сервисов (см. values-ro.yaml)

## Изменение параметра подключения к БД PostreSQL

До версии 5.3.0 параметр подключения сервисов к БД PostgreSQL указывался в values через перечисление значений ```postgresHost```, ```postgresPort```, ```postgresDatabase```, ```postgresUser```, ```postgresPassword```, ```targetSessionAttributes``` вложенных в словарь ```db``` для каждого сервиса или общие ```general.sslConfig```, ```general.config``` в зависимости от настроек SSL, затем эти параметры формировали строку подключения внутри ConfigMap. Начиная с версии 5.3.0 формирование строки подключения к БД производится силами администратора сразу в итоговом формате Npgsql в разделе ```general.secrets``` values.yaml