
{{- define "unichart.pod.tolerations" -}}
{{- if .current.tolerations }}
tolerations: {{ .current.tolerations | toYaml | nindent 2 }}
{{- else if .default.tolerations }}
tolerations: {{ .default.tolerations | toYaml | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.pod.nodeSelector" -}}
{{- if .current.nodeSelector }}
nodeSelector: {{ .current.nodeSelector | toYaml | nindent 2 }}
{{- else if .default.nodeSelector }}
nodeSelector: {{ .default.nodeSelector | toYaml | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.pod.SecurityContext" -}}
{{- if .current.podSecurityContext }}
securityContext: {{ .current.podSecurityContext | toYaml | nindent 2 }}
{{- else if .default.podSecurityContext }}
securityContext: {{ .default.podSecurityContext | toYaml | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.pod.affinity" -}}
affinity:
{{- if .current.affinity }}
  {{- if and .current.affinity.podAffinity (ne .current.podAntiAffinity.enabled false) }}
  {{- fail "You must not use both fields together in affinity section: podAffinity and podAntiAffinity!" }}
  {{- end }}
  {{- toYaml .current.affinity | nindent 2 }}
{{- else if .default.affinity }}
  {{- if and .default.affinity.podAffinity (ne .current.podAntiAffinity.enabled false) }}
  {{- fail "You must not use both fields together in affinity section: podAffinity and podAntiAffinity!" }}
  {{- end }}
  {{- toYaml .default.affinity | nindent 2 }}
{{- end }}
{{- if .current.podAntiAffinity }}
{{- if ne .current.podAntiAffinity.enabled false }}
  podAntiAffinity:
    preferredDuringSchedulingIgnoredDuringExecution:
    - weight: 100
      podAffinityTerm:
        labelSelector:
          matchExpressions:
          - key: app
            operator: In
            values:
            - {{ .name }}
        topologyKey: {{ .current.podAntiAffinity.topologyKey  }}
{{- end }}
{{- else }}
  podAntiAffinity:
    preferredDuringSchedulingIgnoredDuringExecution:
    - weight: 100
      podAffinityTerm:
        labelSelector:
          matchExpressions:
          - key: app
            operator: In
            values:
            - {{ .name }}
        topologyKey: {{ .default.podAntiAffinity.topologyKey  }}
{{- end }}
{{- end -}}

{{- define "unichart.pod.volumes" -}}
{{- if or .current.volumes (and .general.volumes (not .current.excludeGeneralVolumes))}}
volumes:
  {{- range $keyVolume, $valueVolume := .current.volumes }}
  - name: {{ $keyVolume }}
    {{- if $valueVolume.fromConfigMap }}
    configMap:
      name: {{ $valueVolume.fromConfigMap }}
      defaultMode: 511
    {{- else if $valueVolume.emptyDir }}
    emptyDir:
      {{- toYaml $valueVolume.emptyDir | nindent 6 }}
    {{- end }}
  {{- end }}
  {{- if and .general.volumes (not .current.excludeGeneralVolumes) }}
  {{- range $keyVolume, $valueVolume := .general.volumes }}
  - name: {{ $keyVolume }}
    {{- if $valueVolume.fromConfigMap }}
    configMap:
      name: {{ $valueVolume.fromConfigMap }}
      defaultMode: 511
    {{- else if $valueVolume.emptyDir }}
    emptyDir:
      {{- toYaml $valueVolume.emptyDir | nindent 6 }}
    {{- end }}
  {{- end }}
  {{- end }}
{{- end }}
{{- end -}}

{{- define "unichart.pod.imagePullSecrets" -}}
{{- if or ( and .default .default.pullSecrets) ( and .current .current.pullSecrets) }}
imagePullSecrets:
  {{- if and .current .current.pullSecrets }}
  {{- toYaml .current.pullSecrets | nindent 2 }}
  {{- end }}
  {{- if and .default .default.pullSecrets }}
  {{- toYaml .default.pullSecrets | nindent 2 }}
  {{- end }}
{{- end }}
{{- end -}}
