{{- define "unichart.cmMetadata" -}}
metadata:
  name: "{{ .name }}"
  labels:
    app: {{ .app }}
  annotations:
    "helm.sh/hook": pre-install,pre-upgrade,post-install,post-upgrade
    "helm.sh/hook-weight": "-5"
    "helm.sh/hook-delete-policy": before-hook-creation
{{- end -}}

{{- define "unichart.strategy" -}}
{{- if .current.strategy -}}
  {{- toYaml .current.strategy | nindent 2 }}
{{- else if .default.strategy }}
  {{- toYaml .default.strategy | nindent 2 }}
{{- else -}}
  type: RollingUpdate
{{- end -}}
{{- end -}}

{{- define "unichart.selector" -}}
selector:
  matchLabels:
    app: {{ .name }}
    {{- if .current.labels }}
    {{- toYaml .current.labels | nindent 4 }}
    {{- end }}
{{- end -}}

{{- define "unichart.labels" -}}
labels:
  app: {{ .name }}
  {{- if .current.labels }}
  {{- toYaml .current.labels | nindent 2 }}
  {{- end }}
{{- end -}}

{{- define "unichart.annotations" -}}
{{- if or .current.annotations .current.restartOnUpgrade -}}
annotations:
  {{- if .current.annotations -}}
  {{- .current.annotations | toYaml | nindent 2 }}
  {{- end -}}
  {{- if .current.restartOnUpgrade }}
  helm.sh/restartedAt: {{ now | quote }}
  {{- end }}
{{- end -}}
{{- end -}}
