{{- define "unichart.container.probes" -}}
{{- if .current.startupProbe }}
{{- if ne .current.startupProbe.enabled false }}
startupProbe:
  {{- toYaml .current.startupProbe | nindent 2 }}
{{- end }}
{{- else }}
startupProbe:
  httpGet:
    path: {{ .current.probesPath | default .default.probesPath }}
    port: {{ .current.containerPort | default .default.containerPort }}
  {{- toYaml .default.startupProbe | nindent 2 }}
{{- end }}
{{- if .current.readinessProbe }}
{{- if ne .current.readinessProbe.enabled false }}
readinessProbe:
  {{- toYaml .current.readinessProbe | nindent 2 }}
{{- end }}
{{- else }}
readinessProbe:
  httpGet:
    path: {{ .current.probesPath | default .default.probesPath }}
    port: {{ .current.containerPort | default .default.containerPort }}
  {{- toYaml .default.readinessProbe | nindent 2 }}
{{- end }}
{{- if .current.livenessProbe }}
{{- if ne .current.livenessProbe.enabled false }}
livenessProbe:
  {{- toYaml .current.livenessProbe | nindent 2 }}
{{- end }}
{{- else }}
livenessProbe:
  httpGet:
    path: {{ .current.probesPath | default .default.probesPath }}
    port: {{ .current.containerPort | default .default.containerPort }}
  {{- toYaml .default.livenessProbe | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.container.resources" -}}
{{- if .current }}
{{- if ne .current.enabled false }}
resources:
  {{- toYaml .current | nindent 2 }}
{{- end }}
{{- else }}
resources:
  {{- toYaml .default | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.container.securityContext" -}}
{{- if .current.containerSecurityContext }}
securityContext: {{ .current.containerSecurityContext | toYaml | nindent 2 }}
{{- else if .default.containerSecurityContext}}
securityContext: {{ .default.containerSecurityContext | toYaml | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.container.image" -}}
{{- if and .current.image .current.image.repository }}
image: "{{ .current.image.repository }}:{{ .current.image.tag | default .default.tag }}"
imagePullPolicy: {{ .current.image.pullPolicy | default "Always" }}
{{- else }}
image: "{{ .default.repository }}/{{ .name }}:{{ .default.tag }}"
imagePullPolicy: {{ .default.pullPolicy | default "Always" }}
{{- end }}
{{- end -}}

{{- define "unichart.container.commands" -}}
{{- if .current.command }}
command: {{- toYaml .current.command | nindent 2 }}
{{- end }}
{{- if .current.args }}
args: {{- toYaml .current.args | nindent 2 }}
{{- end }}
{{- end -}}

{{- define "unichart.container.envFrom" -}}
{{- if or .current.config .current.configMap .current.secrets (and .general.config (not .parent.excludeGeneralConfig)) }}
envFrom:
{{- if .current.config }}
  - configMapRef:
      name: {{ .name }}-config
{{- end }}
{{- if and .current.configMap (eq .current.configMap (printf "%s-config" .name)) }}
{{- fail "configMap parameter in initContinaer should not be of format container-name-config!" }}
{{- end }}
{{- if .current.configMap }}
  - configMapRef:
      name: {{ .current.configMap }}
{{- end }}
{{- if .current.secrets }}
  - secretRef:
      name: {{ .name }}-secret
{{- end }}
{{- if and .general.config (not .parent.excludeGeneralConfig) }}
  - configMapRef:
      name: general-config
{{- end }}
{{- end }}
{{- end -}}

{{- define "unichart.container.env" -}}
{{- if or .current.env .current.envFromConfigMap .current.envFromSecret }}
env:
{{- range $keyEnv, $valueEnv := .current.env }}
  - name: {{ $keyEnv }}
    value: {{ $valueEnv | quote }}
{{- end }}
{{- range $keyEnv, $valueEnv := .current.envFromConfigMap }}
  - name: {{ $keyEnv }}
    valueFrom: 
      configMapKeyRef: 
        name: {{ $valueEnv.configMapName }}
        key: {{ $valueEnv.configMapKey }}
{{- end }}
{{- range $keyEnv, $valueEnv := .current.envFromSecret }}
  - name: {{ $keyEnv }}
    valueFrom: 
      secretKeyRef: 
        name: {{ $valueEnv.secretName }}
        key: {{ $valueEnv.secretKey }}
{{- end }}
{{- end }}
{{- end -}}

{{- define "unichart.container.volumeMounts" -}}
{{- if or .parent.volumes (and .general.volumes (not .parent.excludeGeneralVolumes)) }}
volumeMounts:
  {{- $containerName := .name }}
  {{- range $keyVolume, $valueVolume := .parent.volumes }}
  {{- range $keyMounts, $valueMounts := $valueVolume.mounts }}
  {{- if eq $containerName $keyMounts }}
  - name: {{ $keyVolume }}
    mountPath: {{ $valueMounts.mountPath }}
    {{- if $valueMounts.subPath }}
    subPath: {{ $valueMounts.subPath }}
    {{- end }}
    {{- if $valueMounts.readOnly }}
    readOnly: true
    {{- end }}
  {{- end }}
  {{- end }}
  {{- end }}
  {{- if and .general.volumes (not .parent.excludeGeneralVolumes) }}
  {{- range $keyVolume, $valueVolume := .general.volumes }}
  - name: {{ $keyVolume }}
    mountPath: {{ $valueVolume.mounts.mountPath }}
    {{- if $valueVolume.mounts.subPath }}
    subPath: {{ $valueVolume.mounts.subPath }}
    {{- end }}
    {{- if $valueVolume.mounts.readOnly }}
    readOnly: true
    {{- end }}
  {{- end }}
  {{- end }}
{{- end }}
{{- end -}}

{{- define "unichart.container.port" -}}
{{- if and .current.service (hasKey .current.service "ports") }}
ports:
{{- range .current.service.ports }}
  - name: {{ .name }}
    containerPort: {{ .port }}
    protocol: {{ .protocol | default "TCP" }}
{{- end }}
{{- else }}
ports:
- containerPort: {{ .current.containerPort | default .default.containerPort }}
{{- end }}
{{- end -}}

{{- define "unichart.container.lifecycle" -}}
{{- if .current.lifecycle }}
lifecycle:
  {{- if .current.lifecycle.default }}
  {{- toYaml .default.lifecycle | nindent 2 }}
  {{- else }}
  {{- toYaml .current.lifecycle | nindent 2 }}
  {{- end }}
{{- end }}
{{- end -}}