#!/bin/bash
# minio-backup.sh

# Configurable options
TARGET_DIR="/backup"

set -euo pipefail

sleep 10

# Download buckets from the source
mirrorBuckets() {
  local source="$1"
  mkdir -p "${TARGET_DIR}/${source}" || true
  aws s3 ls | awk '{print $3}' | while read bucket #######
  do
    if [ "$bucket" == "${TMS_BUCKET_NAME}" ] || [ "$bucket" == "${AVATARS_AWS_BUCKET_NAME}" ]; then
      echo "Migration is in process, please wait..."
      # Get files from the source bucket
      aws s3 cp "s3://$bucket" "${TARGET_DIR}/${bucket}" --recursive >> /dev/null

      # Check for success
      SOURCE_FILES_COUNT=$(aws s3 ls "s3://$bucket" | wc -l)
      TARGET_FILES_COUNT=$(ls "$TARGET_DIR/$bucket" | wc -l)
      RED='\033[0;31m'
      GREEN='\033[0;32m'
      NC='\033[0m'
      if [ "$SOURCE_FILES_COUNT" == "$TARGET_FILES_COUNT" ]; then
        printf "$bucket bucket migrated ${GREEN}sucessfully${NC}! \nSource files count: $SOURCE_FILES_COUNT\nTransferred files count: $TARGET_FILES_COUNT\n";
      else
        printf "$bucket bucket migration ${RED}failed${NC}! \nSource files: $SOURCE_FILES_COUNT\nFiles transferred: $TARGET_FILES_COUNT\n";
        exit 1;
      fi
    else
      echo "Skipping bucket: $bucket"
    fi
  done
}

# The main function to execute migration
main() {
  
  mirrorBuckets "testit"
  chown -R "$USER":"$USER" "$TARGET_DIR"
}

# Execute the main function and handle errors
if main; then
  echo "MiniO migration completed successfully."
  exit 0  # Exit with code 0 for success
else
  echo "Error: MinIO migration failed."
  exit 1  # Exit with code 1 for failure
fi