#!/bin/bash
#clean_backgrounddb.sh
set -euo pipefail

# Sources the common-functions.sh script from the directory path of the current script
source "$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"/common-functions.sh

main() {
  namespace="$1"
  validate_namespace "$namespace"
  # Stop frontend and deployments that use backgrounddb or globalsearchdb
  local deployments=("frontend" "background-service" "webapi" "globalsearch-service")
  stop_deployments "${deployments[@]}"
  local pod=$(pod_by_label "app=postgres")
  local psql_user=$(get_env_variable_from_pod "app=postgres" "POSTGRES_USER")
  execute_psql "$pod" "$psql_user" "backgrounddb" "DROP TABLE IF EXISTS public.\"SearchItems\", public.\"Resources\", public.\"Projects\", public.\"__EFMigrationsHistory\";" &> /dev/null
  echo "Done! Please proceed to the next update step"
}

# Validations before the script
validate_input "$@" 1
command_check "kubectl"
main "$@"